/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.block.BaseBlock;
import dev.toma.gunsrpg.common.container.DeathCrateContainer;
import dev.toma.gunsrpg.common.tileentity.DeathCrateTileEntity;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DeathCrateBlock
extends BaseBlock {
    public static final Marker MARKER = MarkerManager.getMarker((String)"DeathCrates");
    private static final ITextComponent TITLE = new TranslationTextComponent("container.death_crate");
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.4, (double)1.0);

    public DeathCrateBlock(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.2f, 3600000.0f).func_200944_c().func_226896_b_());
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        DeathCrateTileEntity deathCrate;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DeathCrateTileEntity && (deathCrate = (DeathCrateTileEntity)te).isEmpty()) {
            world.func_175655_b(pos, false);
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        return new SimpleNamedContainerProvider((windowID, playerInventory, player) -> new DeathCrateContainer(windowID, playerInventory, (DeathCrateTileEntity)world.func_175625_s(pos)), TITLE);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
        return ActionResultType.CONSUME;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader reader) {
        return new DeathCrateTileEntity();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        GunsRPG.log.debug(MARKER, "Death crate being removed from {}", (Object)pos);
        if (!state.func_203425_a(oldState.func_177230_c())) {
            GunsRPG.log.debug(MARKER, "Dropping crate inventory contents");
            ModUtils.dropInventoryItems(world, pos);
        }
        super.func_196243_a(state, world, pos, oldState, p_196243_5_);
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return Collections.emptyList();
    }
}

